function [LB, UB, D, opt_f, err] = CEC2011get_fun_info(fun)
% Get the lower bound, upper bound, dimension, and optimal value for function # 'fun'
opt_f = -inf;
switch(fun) % CEC 2011 "real world" benchmarks
    case {1} % Frequency modulation sound parameter identification
        LB = -6.4*ones(1,6);
        UB = 6.35*ones(1,6);
        D = 6;
        err = 1e-4;
    case {2, 5, 6}
        D = 30;
        LB = zeros(1,D);
        UB = zeros(1,D);
        UB(1:2) = 4;
        UB(3) = pi;
        LB(4:D) = -4 - floor(((4:D)-4)/3) / 4;
        UB(4:D) = -LB(4:D);
        err = 1e-2;
    case {3}
        LB = 0.6;
        UB = 0.9;
        D = 1;
        err = 1e-4;
    case {4}
        LB = 0;
        UB = 5;
        D = 1;
        err = 1e-2;
    case {7}
        D = 20;
        LB = zeros(1,D);
        UB = 2*pi*ones(1,D);
        err = 1e-3;
    case {8}
        D = 7;
        LB = eps*ones(1,D);
        UB = 15*ones(1,D);
        err = 1e-1;
    case {9}
        D = 126;
        bounds;
        LB = zeros(1,D);
        UB = GD_max';
        UB = UB(:);
        UB = UB';
        err = 10;
    case {10}
        D = 12;
        LB = [0.2*ones(1,D/2), -180*ones(1,D/2)];
        UB = [1.0*ones(1,D/2), +180*ones(1,D/2)];
        err = 1e-1;
    case {111}
        D = 120;
        LB = repmat([10, 20, 30, 40, 50], 1, 24);
        UB = repmat([75, 125, 175, 250, 300], 1, 24);
        err = 10;
    case {112}
        D = 216;
        LB = repmat([150, 135, 73, 60, 73, 57, 20, 47, 20], 1, 24);
        UB = repmat([470, 460, 340, 300, 243, 160, 130, 120, 80], 1, 24);
        err = 100;
    case {113}
        D = 6;
        range = [100 500;50 200;80 300;50 150;50 200;50 120]; 
        LB = range(:,1)';  
        UB = range(:,2)';
        err = 10;
    case {114}
        D = 13;
        range = [0,680;0,360;0,360;60,180;60,180;60,180;60,180;60,180;60,180;40,120;40,120;55,120;55,120];
        LB = range(:,1)';
        UB = range(:,2)';
        err = 10;
    case {115}
        D = 15;
        range = [150,455;150,455;20,130;20,130;150,470;135,460;135,465;60,300;25,162;25,160;20,80;20,80;25,85;15,55;15,55]; 
        LB = range(:,1)';
        UB = range(:,2)';
        err = 10;
    case {116}
        D = 40;
        range=[36,114;36,114;60,120;80,190;47,97;68,140;110,300;135,300;135,300;130,300;94,375;94,375;125,500;125,500;125,500;125,500;220,500;220,500;242,550;242,550;254,550;254,550;254,550;254,550;254,550;254,550;10,150;10,150;10,150;47,97;60,190;60,190;60,190;90,200;90,200;90,200;25,110;25,110;25,110;242,550]; 
        LB = range(:,1)';
        UB = range(:,2)';
        err = 100;
    case {117}
        D = 140;
        range = [71,119;120,189;125,190;125,190;90,190;90,190;280,490;280,490;260,496;260,496;260,496;260,496;260,506;260,509;260,506;260,505;260,506;260,506;260,505;260,505;260,505;260,505;260,505;260,505;280,537;280,537;280,549;280,549;260,501;260,501;260,506;260,506;260,506;260,506;260,500;260,500;120,241;120,241;423,774;423,769;3,19;3,28;160,250;160,250;160,250;160,250;160,250;160,250;160,250;160,250;165,504;165,504;165,504;165,504;180,471;180,561;103,341;198,617;100,312;153,471;163,500;95,302;160,511;160,511;196,490;196,490;196,490;196,490;130,432;130,432;137,455;137,455;195,541;175,536;175,540;175,538;175,540;330,574;160,531;160,531;200,542;56,132;115,245;115,245;115,245;207,307;207,307;175,345;175,345;175,345;175,345;360,580;415,645;795,984;795,978;578,682;615,720;612,718;612,720;758,964;755,958;750,1007;750,1006;713,1013;718,1020;791,954;786,952;795,1006;795,1013;795,1021;795,1015;94,203;94,203;94,203;244,379;244,379;244,379;95,190;95,189;116,194;175,321;2,19;4,59;15,83;9,53;12,37;10,34;112,373;4,20;5,38;5,19;50,98;5,10;42,74;42,74;41,105;17,51;7,19;7,19;26,40];
        LB = range(:,1)';
        UB = range(:,2)';
        err = 100;
    case {118, 119, 1110}
        D = 96;
        LB = repmat([5 6 10 13], 1, 24);  
        UB = repmat([15 15 30 25], 1, 24);
        err = 100;
    case {12}
        D = 26;
        [UB, LB] = getlimit_messenger;
        err = 1e-2;
    case {13}
        D = 22;
        [UB, LB] = getlimit_cassini2;
        err = 1e-2;
    otherwise
        error('function index not implemented')
end
end